/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class RecoverResources
implements HMCCommands {
    private static final String CPU_TYPE = "cpu";
    private static final String MEMORY_TYPE = "mem";
    private static final String SLOT_TYPE = "slot";
    private HSCCECClient hcc = null;
    private HSCClientObjectFactory hcof;
    private HSCLPARClient hlc = null;
    private String drawerId;
    private String intPartitionName;
    private String managedSystem;
    private String resourceType;
    private String partitionName;
    private String physLoc = null;
    private short processorId = (short)-1;
    private short slotId = (short)-1;
    private Vector recoveryMemInfo;
    private Hashtable recoveryCPUInfo;
    private Vector recoveryIOInfo;

    private int validateMemoryPartitions() throws HSCException {
        Hashtable hashtable = null;
        String string = null;
        this.recoveryMemInfo = this.hcc.getRecoverMemoryData();
        if (null != this.partitionName) {
            HSCLPARClient hSCLPARClient = this.hcof.createLPARClient(this.managedSystem, this.partitionName, false);
            if (null == hSCLPARClient) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
            this.intPartitionName = hSCLPARClient.getIntName();
            int n = 0;
            while (n < this.recoveryMemInfo.size()) {
                hashtable = (Hashtable)this.recoveryMemInfo.elementAt(n);
                if (!this.intPartitionName.equals((String)hashtable.get("intNames"))) {
                    return 0;
                }
                ++n;
            }
        } else if (this.recoveryMemInfo != null && this.recoveryMemInfo.size() != 0) {
            return 0;
        }
        return -1;
    }

    private int validateProcessorIds() throws HSCException {
        Object var1_1 = null;
        Short s = null;
        Vector vector = null;
        this.recoveryCPUInfo = this.hcc.getRecoverProcessorData();
        if (-1 != this.processorId) {
            vector = (Vector)this.recoveryCPUInfo.get("stoppedCpuIds");
            int n = 0;
            while (n < vector.size()) {
                s = (Short)vector.elementAt(n);
                if (s == this.processorId) {
                    return 0;
                }
                ++n;
            }
        } else {
            return 0;
        }
        return -1;
    }

    private int validateIOData() throws HSCException {
        Hashtable hashtable = null;
        String string = null;
        String string2 = null;
        Short s = null;
        this.recoveryIOInfo = this.hcc.getRecoverIOData();
        if (null != this.drawerId && -1 != this.slotId) {
            int n = 0;
            while (n < this.recoveryIOInfo.size()) {
                hashtable = (Hashtable)this.recoveryIOInfo.elementAt(n);
                string = (String)hashtable.get("IODrawerDeviceID");
                s = (Short)hashtable.get("SlotID");
                if (string.equals(this.drawerId) && s == this.slotId) {
                    return 0;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.recoveryIOInfo.size()) {
                hashtable = (Hashtable)this.recoveryIOInfo.elementAt(n);
                string2 = (String)hashtable.get("SlotLocation");
                if (string2.equals(this.physLoc)) {
                    this.drawerId = (String)hashtable.get("IODrawerDeviceID");
                    this.slotId = (Short)hashtable.get("SlotID");
                    return 0;
                }
                ++n;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private void doRecoverOperation() throws HSCException, RequiredParameterException {
        block21: {
            block20: {
                var1_1 = null;
                var2_2 = null;
                var3_3 = null;
                var4_4 = 0;
                if (!this.resourceType.equals("mem")) break block20;
                var4_4 = this.validateMemoryPartitions();
                if (var4_4 == -1) {
                    var3_3 = new String[]{new Integer(var4_4).toString()};
                    if (this.partitionName != null) {
                        var1_1 = "The partition entered does not require memory recovery.";
                        var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "PARTITION_MEMORY_NOT_REQUIRE_RECOVERY", var1_1, var3_3);
                    } else {
                        var1_1 = "The system entered does not require memory recovery.";
                        var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "SYSTEM_MEMORY_NOT_REQUIRE_RECOVERY", var1_1, var3_3);
                    }
                    throw new HSCException(var2_2);
                }
                var5_5 = null;
                var6_8 = new Vector<String>();
                if (null != this.partitionName) ** GOTO lbl31
                if (this.recoveryMemInfo != null) {
                    var7_10 = 0;
                    while (var7_10 < this.recoveryMemInfo.size()) {
                        var5_5 = (Hashtable)this.recoveryMemInfo.elementAt(var7_10);
                        var6_8.add((String)var5_5.get("partitionNameInt"));
                        ++var7_10;
                    }
                } else {
                    var1_1 = "There are no recoverable memory resources in the system.";
                    var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_RECOVERABLE_MEMORY", var1_1, var3_3);
                    throw new HSCException(var1_1);
lbl31:
                    // 1 sources

                    var6_8.add(this.intPartitionName);
                }
                this.hcc.recoverMemResources(var6_8);
                break block21;
            }
            if (this.resourceType.equals("cpu")) {
                var4_4 = this.validateProcessorIds();
                if (var4_4 == -1) {
                    var3_3 = new String[]{new Integer(var4_4).toString()};
                    var1_1 = "The processor with the processor ID entered is not a recoverable resource. Please try again.";
                    var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "PROCESSOR_NOT_RECOVERABLE", var1_1, var3_3);
                    throw new HSCException(var1_1);
                }
                var5_6 = new Vector();
                if (-1 == this.processorId) {
                    var5_6 = (Vector)this.recoveryCPUInfo.get("stoppedCpuIds");
                    if (null == var5_6 || var5_6.size() == 0) {
                        var1_1 = "There are no recoverable processor resources in the system.";
                        var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_RECOVERABLE_PROCESSORS", var1_1, var3_3);
                        throw new HSCException(var1_1);
                    }
                } else {
                    var5_6.add(new Short(this.processorId));
                }
                this.hcc.recoverCPUResources(var5_6);
            } else if (this.resourceType.equals("slot")) {
                var4_4 = this.validateIOData();
                if (var4_4 == -1) {
                    var3_3 = new String[]{new Integer(var4_4).toString()};
                    if (this.physLoc == null) {
                        var1_1 = "The I/O device  with the slot ID  and drawer ID entered is not a recoverable resource.";
                        var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "IO_DEVICE_NOT_RECOVERABLE", var1_1, var3_3);
                    } else {
                        var1_1 = "The I/O device  with the physical location code  entered is not a recoverable resource.";
                        var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "IO_DEVICE_PHYS_LOC_NOT_RECOVERABLE", var1_1, var3_3);
                    }
                    throw new HSCException(var1_1);
                }
                var5_7 = null;
                var6_9 = new Vector<String>();
                var7_11 = new Vector<Short>();
                if (null == this.drawerId || -1 == this.slotId) {
                    var8_12 = 0;
                    while (var8_12 < this.recoveryIOInfo.size()) {
                        var5_7 = (Hashtable)this.recoveryIOInfo.elementAt(var8_12);
                        var6_9.add((String)var5_7.get("IODrawerDeviceID"));
                        var7_11.add((Short)var5_7.get("SlotID"));
                        ++var8_12;
                    }
                    if (null == var6_9 || null == var7_11 || var6_9.size() == 0 || var7_11.size() == 0) {
                        var1_1 = "There are no recoverable I/O resources in the system.";
                        var2_2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_RECOVERABLE_IO", var1_1, var3_3);
                        throw new HSCException(var1_1);
                    }
                } else {
                    var6_9.add(this.drawerId);
                    var7_11.add(new Short(this.slotId));
                }
                this.hcc.recoverIOResources(var6_9, var7_11);
            }
        }
    }

    private void initializeClients() throws HSCException {
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        this.hcof = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = this.hcof.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
    }

    private void checkRecoveryRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            if (this.managedSystem == null || this.resourceType == null) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " and " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(CPU_TYPE)) {
            if (this.managedSystem == null || this.resourceType == null) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(SLOT_TYPE) && (this.managedSystem == null || this.resourceType == null)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.SLOT_ID_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DRAWER_ID_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRecoveryRequiredParameters();
        this.initializeClients();
        this.doRecoverOperation();
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        String string;
        String string2 = null;
        String string3 = (String)hashMap.get(HMCCommandUtils.SLOT_ID_PARAM);
        if (string3 != null && string3.length() != 0) {
            this.slotId = Short.parseShort(string3);
        }
        if ((string = (String)hashMap.get(HMCCommandUtils.RECOVERY_PROCESSOR_ID_PARAM)) != null && string.length() != 0) {
            this.processorId = Short.parseShort(string);
        }
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        if (!(this.resourceType == null || this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(SLOT_TYPE))) {
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
            throw new RequiredParameterException(string2);
        }
        this.drawerId = (String)hashMap.get(HMCCommandUtils.DRAWER_ID_PARAM);
        this.physLoc = (String)hashMap.get(HMCCommandUtils.PHYSICAL_LOCATION_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.partitionName = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        if (this.managedSystem == null || this.resourceType == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(SLOT_TYPE)) {
            Object[] objectArray = new String[2];
            if (this.physLoc != null && this.drawerId != null && this.slotId != -1) {
                objectArray[0] = HMCCommandUtils.PHYSICAL_LOCATION_PARAM;
                objectArray[1] = HMCCommandUtils.DRAWER_ID_PARAM + ", " + HMCCommandUtils.SLOT_ID_PARAM;
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_CONFLICT_ARGS", null, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RECOVER_RESOURCES_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        RecoverResources recoverResources = new RecoverResources();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                recoverResources.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    recoverResources.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                recoverResources.mapParameters(hashMap);
                recoverResources.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            HSCLogUtils.clientLog(hSCException, HSCLogUtils._LPARClassLogInfo);
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            HSCLogUtils.clientLog(exception, HSCLogUtils._LPARClassLogInfo);
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

